/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBHeaderMegaMenu = Object.create(STBModule.prototype);

STBHeaderMegaMenu.name = "HeaderMegaMenu";
STBHeaderMegaMenu.updateStyle = function () {

	var $megaDropdown = $('.mega-dropdown');

	var dropDownClassAdd = function() {
		$("body").addClass($(this).attr("data-style"));
		//carousels will have 0px height without refresh.
		$(this).find(".owl-carousel").trigger("refresh");


		if (!$("body").hasClass("moveMainNav") && !$("body").hasClass("moveSecNav")) {
			var elements = $(this).find(".widget-head");
			elements.removeClass("animated-title").addClass("clear-animation");

			setTimeout(function(){			
				elements.removeClass("clear-animation").addClass("animated-title");
			}, 1);
		}
	}

	var dropDownClassRemove = function() {
		$("body").removeClass($(this).attr("data-style"));
	}

	$megaDropdown.hover(dropDownClassAdd , dropDownClassRemove);


	//add control classes to identify the menu holder. z-index & pos relative issue
	
	if ($megaDropdown.length){
		$megaDropdown.each(function() {
			var holder = $(this).closest(".navbar");

			if (holder.hasClass("sec-nav")) {
				$(this).attr("data-style" , $(this).attr("data-style") + " with-sec-nav");
			}

			if (holder.hasClass("main-nav")) {
				$(this).attr("data-style" , $(this).attr("data-style") + " with-main-nav");
			}

		});
	}

}


STBHeaderMegaMenu.updateActive = function() {
	if ($("header .active").length){
	} else {
		//detect a link ( it might be in mega menu )

		var url = window.location.href,
			base = $("base").attr("href"),
			left = url.replace(base , "/"),
			link = $("header a[href='" + left +"']");

		if (!link.length){
			link = $("header a[href='" + url +"']");
		}

		if (link.length > 0) {

			var parent = link.closest("li"),
				holder = link.closest(".dropdown");

			if (parent.length > 0) {
				parent.addClass("active");
			}

			if (holder.length > 0) {
				holder.addClass("active");
			}
		}
	}

}


STBHeaderMegaMenu.runOnReady = function() {
	STBHeaderMegaMenu.updateStyle();
	STBHeaderMegaMenu.updateActive();
}


site.registerModule(STBHeaderMegaMenu);